import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetTransitGatewayPrefixListReferencesRequest, GetTransitGatewayPrefixListReferencesResult, } from "../models/models_5";
import { deserializeAws_ec2GetTransitGatewayPrefixListReferencesCommand, serializeAws_ec2GetTransitGatewayPrefixListReferencesCommand, } from "../protocols/Aws_ec2";
var GetTransitGatewayPrefixListReferencesCommand = (function (_super) {
    __extends(GetTransitGatewayPrefixListReferencesCommand, _super);
    function GetTransitGatewayPrefixListReferencesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetTransitGatewayPrefixListReferencesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetTransitGatewayPrefixListReferencesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetTransitGatewayPrefixListReferencesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetTransitGatewayPrefixListReferencesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetTransitGatewayPrefixListReferencesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetTransitGatewayPrefixListReferencesCommand(input, context);
    };
    GetTransitGatewayPrefixListReferencesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetTransitGatewayPrefixListReferencesCommand(output, context);
    };
    return GetTransitGatewayPrefixListReferencesCommand;
}($Command));
export { GetTransitGatewayPrefixListReferencesCommand };
