import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetSerialConsoleAccessStatusRequest, GetSerialConsoleAccessStatusResult } from "../models/models_5";
import { deserializeAws_ec2GetSerialConsoleAccessStatusCommand, serializeAws_ec2GetSerialConsoleAccessStatusCommand, } from "../protocols/Aws_ec2";
var GetSerialConsoleAccessStatusCommand = (function (_super) {
    __extends(GetSerialConsoleAccessStatusCommand, _super);
    function GetSerialConsoleAccessStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetSerialConsoleAccessStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetSerialConsoleAccessStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetSerialConsoleAccessStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetSerialConsoleAccessStatusResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetSerialConsoleAccessStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetSerialConsoleAccessStatusCommand(input, context);
    };
    GetSerialConsoleAccessStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetSerialConsoleAccessStatusCommand(output, context);
    };
    return GetSerialConsoleAccessStatusCommand;
}($Command));
export { GetSerialConsoleAccessStatusCommand };
