import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetPasswordDataRequest, GetPasswordDataResult } from "../models/models_5";
import { deserializeAws_ec2GetPasswordDataCommand, serializeAws_ec2GetPasswordDataCommand } from "../protocols/Aws_ec2";
var GetPasswordDataCommand = (function (_super) {
    __extends(GetPasswordDataCommand, _super);
    function GetPasswordDataCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetPasswordDataCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetPasswordDataCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetPasswordDataRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetPasswordDataResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetPasswordDataCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetPasswordDataCommand(input, context);
    };
    GetPasswordDataCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetPasswordDataCommand(output, context);
    };
    return GetPasswordDataCommand;
}($Command));
export { GetPasswordDataCommand };
