import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetNetworkInsightsAccessScopeContentRequest, GetNetworkInsightsAccessScopeContentResult, } from "../models/models_5";
import { deserializeAws_ec2GetNetworkInsightsAccessScopeContentCommand, serializeAws_ec2GetNetworkInsightsAccessScopeContentCommand, } from "../protocols/Aws_ec2";
var GetNetworkInsightsAccessScopeContentCommand = (function (_super) {
    __extends(GetNetworkInsightsAccessScopeContentCommand, _super);
    function GetNetworkInsightsAccessScopeContentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetNetworkInsightsAccessScopeContentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetNetworkInsightsAccessScopeContentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetNetworkInsightsAccessScopeContentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetNetworkInsightsAccessScopeContentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetNetworkInsightsAccessScopeContentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetNetworkInsightsAccessScopeContentCommand(input, context);
    };
    GetNetworkInsightsAccessScopeContentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetNetworkInsightsAccessScopeContentCommand(output, context);
    };
    return GetNetworkInsightsAccessScopeContentCommand;
}($Command));
export { GetNetworkInsightsAccessScopeContentCommand };
