import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetNetworkInsightsAccessScopeAnalysisFindingsRequest, GetNetworkInsightsAccessScopeAnalysisFindingsResult, } from "../models/models_5";
import { deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand, serializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand, } from "../protocols/Aws_ec2";
var GetNetworkInsightsAccessScopeAnalysisFindingsCommand = (function (_super) {
    __extends(GetNetworkInsightsAccessScopeAnalysisFindingsCommand, _super);
    function GetNetworkInsightsAccessScopeAnalysisFindingsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetNetworkInsightsAccessScopeAnalysisFindingsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetNetworkInsightsAccessScopeAnalysisFindingsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetNetworkInsightsAccessScopeAnalysisFindingsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetNetworkInsightsAccessScopeAnalysisFindingsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetNetworkInsightsAccessScopeAnalysisFindingsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand(input, context);
    };
    GetNetworkInsightsAccessScopeAnalysisFindingsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand(output, context);
    };
    return GetNetworkInsightsAccessScopeAnalysisFindingsCommand;
}($Command));
export { GetNetworkInsightsAccessScopeAnalysisFindingsCommand };
