import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetManagedPrefixListEntriesRequest, GetManagedPrefixListEntriesResult } from "../models/models_5";
import { deserializeAws_ec2GetManagedPrefixListEntriesCommand, serializeAws_ec2GetManagedPrefixListEntriesCommand, } from "../protocols/Aws_ec2";
var GetManagedPrefixListEntriesCommand = (function (_super) {
    __extends(GetManagedPrefixListEntriesCommand, _super);
    function GetManagedPrefixListEntriesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetManagedPrefixListEntriesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetManagedPrefixListEntriesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetManagedPrefixListEntriesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetManagedPrefixListEntriesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetManagedPrefixListEntriesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetManagedPrefixListEntriesCommand(input, context);
    };
    GetManagedPrefixListEntriesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetManagedPrefixListEntriesCommand(output, context);
    };
    return GetManagedPrefixListEntriesCommand;
}($Command));
export { GetManagedPrefixListEntriesCommand };
