import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetGroupsForCapacityReservationRequest, GetGroupsForCapacityReservationResult } from "../models/models_4";
import { deserializeAws_ec2GetGroupsForCapacityReservationCommand, serializeAws_ec2GetGroupsForCapacityReservationCommand, } from "../protocols/Aws_ec2";
var GetGroupsForCapacityReservationCommand = (function (_super) {
    __extends(GetGroupsForCapacityReservationCommand, _super);
    function GetGroupsForCapacityReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetGroupsForCapacityReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetGroupsForCapacityReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetGroupsForCapacityReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetGroupsForCapacityReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetGroupsForCapacityReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetGroupsForCapacityReservationCommand(input, context);
    };
    GetGroupsForCapacityReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetGroupsForCapacityReservationCommand(output, context);
    };
    return GetGroupsForCapacityReservationCommand;
}($Command));
export { GetGroupsForCapacityReservationCommand };
