import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetEbsDefaultKmsKeyIdRequest, GetEbsDefaultKmsKeyIdResult } from "../models/models_4";
import { deserializeAws_ec2GetEbsDefaultKmsKeyIdCommand, serializeAws_ec2GetEbsDefaultKmsKeyIdCommand, } from "../protocols/Aws_ec2";
var GetEbsDefaultKmsKeyIdCommand = (function (_super) {
    __extends(GetEbsDefaultKmsKeyIdCommand, _super);
    function GetEbsDefaultKmsKeyIdCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetEbsDefaultKmsKeyIdCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetEbsDefaultKmsKeyIdCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetEbsDefaultKmsKeyIdRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetEbsDefaultKmsKeyIdResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetEbsDefaultKmsKeyIdCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetEbsDefaultKmsKeyIdCommand(input, context);
    };
    GetEbsDefaultKmsKeyIdCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetEbsDefaultKmsKeyIdCommand(output, context);
    };
    return GetEbsDefaultKmsKeyIdCommand;
}($Command));
export { GetEbsDefaultKmsKeyIdCommand };
