import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetDefaultCreditSpecificationRequest, GetDefaultCreditSpecificationResult } from "../models/models_4";
import { deserializeAws_ec2GetDefaultCreditSpecificationCommand, serializeAws_ec2GetDefaultCreditSpecificationCommand, } from "../protocols/Aws_ec2";
var GetDefaultCreditSpecificationCommand = (function (_super) {
    __extends(GetDefaultCreditSpecificationCommand, _super);
    function GetDefaultCreditSpecificationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetDefaultCreditSpecificationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetDefaultCreditSpecificationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetDefaultCreditSpecificationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetDefaultCreditSpecificationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetDefaultCreditSpecificationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetDefaultCreditSpecificationCommand(input, context);
    };
    GetDefaultCreditSpecificationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetDefaultCreditSpecificationCommand(output, context);
    };
    return GetDefaultCreditSpecificationCommand;
}($Command));
export { GetDefaultCreditSpecificationCommand };
