import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetCoipPoolUsageRequest, GetCoipPoolUsageResult } from "../models/models_4";
import { deserializeAws_ec2GetCoipPoolUsageCommand, serializeAws_ec2GetCoipPoolUsageCommand, } from "../protocols/Aws_ec2";
var GetCoipPoolUsageCommand = (function (_super) {
    __extends(GetCoipPoolUsageCommand, _super);
    function GetCoipPoolUsageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetCoipPoolUsageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetCoipPoolUsageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetCoipPoolUsageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetCoipPoolUsageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetCoipPoolUsageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetCoipPoolUsageCommand(input, context);
    };
    GetCoipPoolUsageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetCoipPoolUsageCommand(output, context);
    };
    return GetCoipPoolUsageCommand;
}($Command));
export { GetCoipPoolUsageCommand };
