import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetCapacityReservationUsageRequest, GetCapacityReservationUsageResult } from "../models/models_4";
import { deserializeAws_ec2GetCapacityReservationUsageCommand, serializeAws_ec2GetCapacityReservationUsageCommand, } from "../protocols/Aws_ec2";
var GetCapacityReservationUsageCommand = (function (_super) {
    __extends(GetCapacityReservationUsageCommand, _super);
    function GetCapacityReservationUsageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetCapacityReservationUsageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetCapacityReservationUsageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetCapacityReservationUsageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetCapacityReservationUsageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetCapacityReservationUsageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetCapacityReservationUsageCommand(input, context);
    };
    GetCapacityReservationUsageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetCapacityReservationUsageCommand(output, context);
    };
    return GetCapacityReservationUsageCommand;
}($Command));
export { GetCapacityReservationUsageCommand };
