import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableVgwRoutePropagationRequest } from "../models/models_4";
import { deserializeAws_ec2EnableVgwRoutePropagationCommand, serializeAws_ec2EnableVgwRoutePropagationCommand, } from "../protocols/Aws_ec2";
var EnableVgwRoutePropagationCommand = (function (_super) {
    __extends(EnableVgwRoutePropagationCommand, _super);
    function EnableVgwRoutePropagationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableVgwRoutePropagationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableVgwRoutePropagationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableVgwRoutePropagationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableVgwRoutePropagationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableVgwRoutePropagationCommand(input, context);
    };
    EnableVgwRoutePropagationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableVgwRoutePropagationCommand(output, context);
    };
    return EnableVgwRoutePropagationCommand;
}($Command));
export { EnableVgwRoutePropagationCommand };
