import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableImageDeprecationRequest, EnableImageDeprecationResult } from "../models/models_4";
import { deserializeAws_ec2EnableImageDeprecationCommand, serializeAws_ec2EnableImageDeprecationCommand, } from "../protocols/Aws_ec2";
var EnableImageDeprecationCommand = (function (_super) {
    __extends(EnableImageDeprecationCommand, _super);
    function EnableImageDeprecationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableImageDeprecationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableImageDeprecationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableImageDeprecationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableImageDeprecationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableImageDeprecationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableImageDeprecationCommand(input, context);
    };
    EnableImageDeprecationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableImageDeprecationCommand(output, context);
    };
    return EnableImageDeprecationCommand;
}($Command));
export { EnableImageDeprecationCommand };
