import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateRouteTableRequest } from "../models/models_4";
import { deserializeAws_ec2DisassociateRouteTableCommand, serializeAws_ec2DisassociateRouteTableCommand, } from "../protocols/Aws_ec2";
var DisassociateRouteTableCommand = (function (_super) {
    __extends(DisassociateRouteTableCommand, _super);
    function DisassociateRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateRouteTableCommand(input, context);
    };
    DisassociateRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateRouteTableCommand(output, context);
    };
    return DisassociateRouteTableCommand;
}($Command));
export { DisassociateRouteTableCommand };
