import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateInstanceEventWindowRequest, DisassociateInstanceEventWindowResult } from "../models/models_4";
import { deserializeAws_ec2DisassociateInstanceEventWindowCommand, serializeAws_ec2DisassociateInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
var DisassociateInstanceEventWindowCommand = (function (_super) {
    __extends(DisassociateInstanceEventWindowCommand, _super);
    function DisassociateInstanceEventWindowCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateInstanceEventWindowCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateInstanceEventWindowCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateInstanceEventWindowRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateInstanceEventWindowResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateInstanceEventWindowCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateInstanceEventWindowCommand(input, context);
    };
    DisassociateInstanceEventWindowCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateInstanceEventWindowCommand(output, context);
    };
    return DisassociateInstanceEventWindowCommand;
}($Command));
export { DisassociateInstanceEventWindowCommand };
