import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableVpcClassicLinkDnsSupportRequest, DisableVpcClassicLinkDnsSupportResult } from "../models/models_4";
import { deserializeAws_ec2DisableVpcClassicLinkDnsSupportCommand, serializeAws_ec2DisableVpcClassicLinkDnsSupportCommand, } from "../protocols/Aws_ec2";
var DisableVpcClassicLinkDnsSupportCommand = (function (_super) {
    __extends(DisableVpcClassicLinkDnsSupportCommand, _super);
    function DisableVpcClassicLinkDnsSupportCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableVpcClassicLinkDnsSupportCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableVpcClassicLinkDnsSupportCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableVpcClassicLinkDnsSupportRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableVpcClassicLinkDnsSupportResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableVpcClassicLinkDnsSupportCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableVpcClassicLinkDnsSupportCommand(input, context);
    };
    DisableVpcClassicLinkDnsSupportCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableVpcClassicLinkDnsSupportCommand(output, context);
    };
    return DisableVpcClassicLinkDnsSupportCommand;
}($Command));
export { DisableVpcClassicLinkDnsSupportCommand };
