import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DetachInternetGatewayRequest } from "../models/models_4";
import { deserializeAws_ec2DetachInternetGatewayCommand, serializeAws_ec2DetachInternetGatewayCommand, } from "../protocols/Aws_ec2";
var DetachInternetGatewayCommand = (function (_super) {
    __extends(DetachInternetGatewayCommand, _super);
    function DetachInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DetachInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DetachInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DetachInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DetachInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DetachInternetGatewayCommand(input, context);
    };
    DetachInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DetachInternetGatewayCommand(output, context);
    };
    return DetachInternetGatewayCommand;
}($Command));
export { DetachInternetGatewayCommand };
