import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DetachClassicLinkVpcRequest, DetachClassicLinkVpcResult } from "../models/models_4";
import { deserializeAws_ec2DetachClassicLinkVpcCommand, serializeAws_ec2DetachClassicLinkVpcCommand, } from "../protocols/Aws_ec2";
var DetachClassicLinkVpcCommand = (function (_super) {
    __extends(DetachClassicLinkVpcCommand, _super);
    function DetachClassicLinkVpcCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DetachClassicLinkVpcCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DetachClassicLinkVpcCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DetachClassicLinkVpcRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DetachClassicLinkVpcResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DetachClassicLinkVpcCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DetachClassicLinkVpcCommand(input, context);
    };
    DetachClassicLinkVpcCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DetachClassicLinkVpcCommand(output, context);
    };
    return DetachClassicLinkVpcCommand;
}($Command));
export { DetachClassicLinkVpcCommand };
