import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointsCommand, serializeAws_ec2DescribeVpcEndpointsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointsCommand = (function (_super) {
    __extends(DescribeVpcEndpointsCommand, _super);
    function DescribeVpcEndpointsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointsCommand(input, context);
    };
    DescribeVpcEndpointsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointsCommand(output, context);
    };
    return DescribeVpcEndpointsCommand;
}($Command));
export { DescribeVpcEndpointsCommand };
