import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcAttributeRequest, DescribeVpcAttributeResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcAttributeCommand, serializeAws_ec2DescribeVpcAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeVpcAttributeCommand = (function (_super) {
    __extends(DescribeVpcAttributeCommand, _super);
    function DescribeVpcAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcAttributeCommand(input, context);
    };
    DescribeVpcAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcAttributeCommand(output, context);
    };
    return DescribeVpcAttributeCommand;
}($Command));
export { DescribeVpcAttributeCommand };
