import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTrunkInterfaceAssociationsRequest, DescribeTrunkInterfaceAssociationsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeTrunkInterfaceAssociationsCommand, serializeAws_ec2DescribeTrunkInterfaceAssociationsCommand, } from "../protocols/Aws_ec2";
var DescribeTrunkInterfaceAssociationsCommand = (function (_super) {
    __extends(DescribeTrunkInterfaceAssociationsCommand, _super);
    function DescribeTrunkInterfaceAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTrunkInterfaceAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTrunkInterfaceAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTrunkInterfaceAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTrunkInterfaceAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTrunkInterfaceAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTrunkInterfaceAssociationsCommand(input, context);
    };
    DescribeTrunkInterfaceAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTrunkInterfaceAssociationsCommand(output, context);
    };
    return DescribeTrunkInterfaceAssociationsCommand;
}($Command));
export { DescribeTrunkInterfaceAssociationsCommand };
