import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayVpcAttachmentsRequest, DescribeTransitGatewayVpcAttachmentsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand, serializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayVpcAttachmentsCommand = (function (_super) {
    __extends(DescribeTransitGatewayVpcAttachmentsCommand, _super);
    function DescribeTransitGatewayVpcAttachmentsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayVpcAttachmentsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayVpcAttachmentsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayVpcAttachmentsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayVpcAttachmentsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayVpcAttachmentsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand(input, context);
    };
    DescribeTransitGatewayVpcAttachmentsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand(output, context);
    };
    return DescribeTransitGatewayVpcAttachmentsCommand;
}($Command));
export { DescribeTransitGatewayVpcAttachmentsCommand };
