import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayPeeringAttachmentsRequest, DescribeTransitGatewayPeeringAttachmentsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand, serializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayPeeringAttachmentsCommand = (function (_super) {
    __extends(DescribeTransitGatewayPeeringAttachmentsCommand, _super);
    function DescribeTransitGatewayPeeringAttachmentsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayPeeringAttachmentsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayPeeringAttachmentsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayPeeringAttachmentsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayPeeringAttachmentsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayPeeringAttachmentsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand(input, context);
    };
    DescribeTransitGatewayPeeringAttachmentsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand(output, context);
    };
    return DescribeTransitGatewayPeeringAttachmentsCommand;
}($Command));
export { DescribeTransitGatewayPeeringAttachmentsCommand };
