import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayConnectPeersRequest, DescribeTransitGatewayConnectPeersResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayConnectPeersCommand, serializeAws_ec2DescribeTransitGatewayConnectPeersCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayConnectPeersCommand = (function (_super) {
    __extends(DescribeTransitGatewayConnectPeersCommand, _super);
    function DescribeTransitGatewayConnectPeersCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayConnectPeersCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayConnectPeersCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayConnectPeersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayConnectPeersResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayConnectPeersCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayConnectPeersCommand(input, context);
    };
    DescribeTransitGatewayConnectPeersCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayConnectPeersCommand(output, context);
    };
    return DescribeTransitGatewayConnectPeersCommand;
}($Command));
export { DescribeTransitGatewayConnectPeersCommand };
