import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTrafficMirrorSessionsRequest, DescribeTrafficMirrorSessionsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTrafficMirrorSessionsCommand, serializeAws_ec2DescribeTrafficMirrorSessionsCommand, } from "../protocols/Aws_ec2";
var DescribeTrafficMirrorSessionsCommand = (function (_super) {
    __extends(DescribeTrafficMirrorSessionsCommand, _super);
    function DescribeTrafficMirrorSessionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTrafficMirrorSessionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTrafficMirrorSessionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTrafficMirrorSessionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTrafficMirrorSessionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTrafficMirrorSessionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTrafficMirrorSessionsCommand(input, context);
    };
    DescribeTrafficMirrorSessionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTrafficMirrorSessionsCommand(output, context);
    };
    return DescribeTrafficMirrorSessionsCommand;
}($Command));
export { DescribeTrafficMirrorSessionsCommand };
