import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTrafficMirrorFiltersRequest, DescribeTrafficMirrorFiltersResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTrafficMirrorFiltersCommand, serializeAws_ec2DescribeTrafficMirrorFiltersCommand, } from "../protocols/Aws_ec2";
var DescribeTrafficMirrorFiltersCommand = (function (_super) {
    __extends(DescribeTrafficMirrorFiltersCommand, _super);
    function DescribeTrafficMirrorFiltersCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTrafficMirrorFiltersCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTrafficMirrorFiltersCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTrafficMirrorFiltersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTrafficMirrorFiltersResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTrafficMirrorFiltersCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTrafficMirrorFiltersCommand(input, context);
    };
    DescribeTrafficMirrorFiltersCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTrafficMirrorFiltersCommand(output, context);
    };
    return DescribeTrafficMirrorFiltersCommand;
}($Command));
export { DescribeTrafficMirrorFiltersCommand };
