import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResponse } from "../models/models_4";
import { deserializeAws_ec2DescribeSpotFleetRequestHistoryCommand, serializeAws_ec2DescribeSpotFleetRequestHistoryCommand, } from "../protocols/Aws_ec2";
var DescribeSpotFleetRequestHistoryCommand = (function (_super) {
    __extends(DescribeSpotFleetRequestHistoryCommand, _super);
    function DescribeSpotFleetRequestHistoryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSpotFleetRequestHistoryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSpotFleetRequestHistoryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSpotFleetRequestHistoryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSpotFleetRequestHistoryResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSpotFleetRequestHistoryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSpotFleetRequestHistoryCommand(input, context);
    };
    DescribeSpotFleetRequestHistoryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSpotFleetRequestHistoryCommand(output, context);
    };
    return DescribeSpotFleetRequestHistoryCommand;
}($Command));
export { DescribeSpotFleetRequestHistoryCommand };
