import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSnapshotAttributeCommand, serializeAws_ec2DescribeSnapshotAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeSnapshotAttributeCommand = (function (_super) {
    __extends(DescribeSnapshotAttributeCommand, _super);
    function DescribeSnapshotAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSnapshotAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSnapshotAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSnapshotAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSnapshotAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSnapshotAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSnapshotAttributeCommand(input, context);
    };
    DescribeSnapshotAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSnapshotAttributeCommand(output, context);
    };
    return DescribeSnapshotAttributeCommand;
}($Command));
export { DescribeSnapshotAttributeCommand };
