import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSecurityGroupsRequest, DescribeSecurityGroupsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSecurityGroupsCommand, serializeAws_ec2DescribeSecurityGroupsCommand, } from "../protocols/Aws_ec2";
var DescribeSecurityGroupsCommand = (function (_super) {
    __extends(DescribeSecurityGroupsCommand, _super);
    function DescribeSecurityGroupsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSecurityGroupsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSecurityGroupsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSecurityGroupsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSecurityGroupsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSecurityGroupsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSecurityGroupsCommand(input, context);
    };
    DescribeSecurityGroupsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSecurityGroupsCommand(output, context);
    };
    return DescribeSecurityGroupsCommand;
}($Command));
export { DescribeSecurityGroupsCommand };
