import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSecurityGroupReferencesRequest, DescribeSecurityGroupReferencesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSecurityGroupReferencesCommand, serializeAws_ec2DescribeSecurityGroupReferencesCommand, } from "../protocols/Aws_ec2";
var DescribeSecurityGroupReferencesCommand = (function (_super) {
    __extends(DescribeSecurityGroupReferencesCommand, _super);
    function DescribeSecurityGroupReferencesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSecurityGroupReferencesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSecurityGroupReferencesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSecurityGroupReferencesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSecurityGroupReferencesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSecurityGroupReferencesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSecurityGroupReferencesCommand(input, context);
    };
    DescribeSecurityGroupReferencesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSecurityGroupReferencesCommand(output, context);
    };
    return DescribeSecurityGroupReferencesCommand;
}($Command));
export { DescribeSecurityGroupReferencesCommand };
