import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeRouteTablesRequest, DescribeRouteTablesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeRouteTablesCommand, serializeAws_ec2DescribeRouteTablesCommand, } from "../protocols/Aws_ec2";
var DescribeRouteTablesCommand = (function (_super) {
    __extends(DescribeRouteTablesCommand, _super);
    function DescribeRouteTablesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeRouteTablesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeRouteTablesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeRouteTablesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeRouteTablesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeRouteTablesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeRouteTablesCommand(input, context);
    };
    DescribeRouteTablesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeRouteTablesCommand(output, context);
    };
    return DescribeRouteTablesCommand;
}($Command));
export { DescribeRouteTablesCommand };
