import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeReservedInstancesModificationsRequest } from "../models/models_3";
import { DescribeReservedInstancesModificationsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeReservedInstancesModificationsCommand, serializeAws_ec2DescribeReservedInstancesModificationsCommand, } from "../protocols/Aws_ec2";
var DescribeReservedInstancesModificationsCommand = (function (_super) {
    __extends(DescribeReservedInstancesModificationsCommand, _super);
    function DescribeReservedInstancesModificationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeReservedInstancesModificationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeReservedInstancesModificationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeReservedInstancesModificationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeReservedInstancesModificationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeReservedInstancesModificationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeReservedInstancesModificationsCommand(input, context);
    };
    DescribeReservedInstancesModificationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeReservedInstancesModificationsCommand(output, context);
    };
    return DescribeReservedInstancesModificationsCommand;
}($Command));
export { DescribeReservedInstancesModificationsCommand };
