import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeRegionsRequest, DescribeRegionsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeRegionsCommand, serializeAws_ec2DescribeRegionsCommand } from "../protocols/Aws_ec2";
var DescribeRegionsCommand = (function (_super) {
    __extends(DescribeRegionsCommand, _super);
    function DescribeRegionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeRegionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeRegionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeRegionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeRegionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeRegionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeRegionsCommand(input, context);
    };
    DescribeRegionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeRegionsCommand(output, context);
    };
    return DescribeRegionsCommand;
}($Command));
export { DescribeRegionsCommand };
