import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribePrefixListsRequest, DescribePrefixListsResult } from "../models/models_3";
import { deserializeAws_ec2DescribePrefixListsCommand, serializeAws_ec2DescribePrefixListsCommand, } from "../protocols/Aws_ec2";
var DescribePrefixListsCommand = (function (_super) {
    __extends(DescribePrefixListsCommand, _super);
    function DescribePrefixListsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribePrefixListsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribePrefixListsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribePrefixListsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribePrefixListsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribePrefixListsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribePrefixListsCommand(input, context);
    };
    DescribePrefixListsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribePrefixListsCommand(output, context);
    };
    return DescribePrefixListsCommand;
}($Command));
export { DescribePrefixListsCommand };
