import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkAclsRequest, DescribeNetworkAclsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkAclsCommand, serializeAws_ec2DescribeNetworkAclsCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkAclsCommand = (function (_super) {
    __extends(DescribeNetworkAclsCommand, _super);
    function DescribeNetworkAclsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkAclsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkAclsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkAclsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkAclsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkAclsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkAclsCommand(input, context);
    };
    DescribeNetworkAclsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkAclsCommand(output, context);
    };
    return DescribeNetworkAclsCommand;
}($Command));
export { DescribeNetworkAclsCommand };
