import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLaunchTemplateVersionsRequest, DescribeLaunchTemplateVersionsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeLaunchTemplateVersionsCommand, serializeAws_ec2DescribeLaunchTemplateVersionsCommand, } from "../protocols/Aws_ec2";
var DescribeLaunchTemplateVersionsCommand = (function (_super) {
    __extends(DescribeLaunchTemplateVersionsCommand, _super);
    function DescribeLaunchTemplateVersionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLaunchTemplateVersionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLaunchTemplateVersionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLaunchTemplateVersionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLaunchTemplateVersionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLaunchTemplateVersionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLaunchTemplateVersionsCommand(input, context);
    };
    DescribeLaunchTemplateVersionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLaunchTemplateVersionsCommand(output, context);
    };
    return DescribeLaunchTemplateVersionsCommand;
}($Command));
export { DescribeLaunchTemplateVersionsCommand };
