import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInstanceEventNotificationAttributesRequest, DescribeInstanceEventNotificationAttributesResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeInstanceEventNotificationAttributesCommand, serializeAws_ec2DescribeInstanceEventNotificationAttributesCommand, } from "../protocols/Aws_ec2";
var DescribeInstanceEventNotificationAttributesCommand = (function (_super) {
    __extends(DescribeInstanceEventNotificationAttributesCommand, _super);
    function DescribeInstanceEventNotificationAttributesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInstanceEventNotificationAttributesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInstanceEventNotificationAttributesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInstanceEventNotificationAttributesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInstanceEventNotificationAttributesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInstanceEventNotificationAttributesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInstanceEventNotificationAttributesCommand(input, context);
    };
    DescribeInstanceEventNotificationAttributesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInstanceEventNotificationAttributesCommand(output, context);
    };
    return DescribeInstanceEventNotificationAttributesCommand;
}($Command));
export { DescribeInstanceEventNotificationAttributesCommand };
