import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInstanceCreditSpecificationsRequest, DescribeInstanceCreditSpecificationsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeInstanceCreditSpecificationsCommand, serializeAws_ec2DescribeInstanceCreditSpecificationsCommand, } from "../protocols/Aws_ec2";
var DescribeInstanceCreditSpecificationsCommand = (function (_super) {
    __extends(DescribeInstanceCreditSpecificationsCommand, _super);
    function DescribeInstanceCreditSpecificationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInstanceCreditSpecificationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInstanceCreditSpecificationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInstanceCreditSpecificationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInstanceCreditSpecificationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInstanceCreditSpecificationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInstanceCreditSpecificationsCommand(input, context);
    };
    DescribeInstanceCreditSpecificationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInstanceCreditSpecificationsCommand(output, context);
    };
    return DescribeInstanceCreditSpecificationsCommand;
}($Command));
export { DescribeInstanceCreditSpecificationsCommand };
