import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInstanceAttributeRequest, InstanceAttribute } from "../models/models_3";
import { deserializeAws_ec2DescribeInstanceAttributeCommand, serializeAws_ec2DescribeInstanceAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeInstanceAttributeCommand = (function (_super) {
    __extends(DescribeInstanceAttributeCommand, _super);
    function DescribeInstanceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInstanceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInstanceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInstanceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: InstanceAttribute.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInstanceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInstanceAttributeCommand(input, context);
    };
    DescribeInstanceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInstanceAttributeCommand(output, context);
    };
    return DescribeInstanceAttributeCommand;
}($Command));
export { DescribeInstanceAttributeCommand };
