import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResult } from "../models/models_3";
import { deserializeAws_ec2DescribeImportSnapshotTasksCommand, serializeAws_ec2DescribeImportSnapshotTasksCommand, } from "../protocols/Aws_ec2";
var DescribeImportSnapshotTasksCommand = (function (_super) {
    __extends(DescribeImportSnapshotTasksCommand, _super);
    function DescribeImportSnapshotTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeImportSnapshotTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeImportSnapshotTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeImportSnapshotTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeImportSnapshotTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeImportSnapshotTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeImportSnapshotTasksCommand(input, context);
    };
    DescribeImportSnapshotTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeImportSnapshotTasksCommand(output, context);
    };
    return DescribeImportSnapshotTasksCommand;
}($Command));
export { DescribeImportSnapshotTasksCommand };
