import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIamInstanceProfileAssociationsRequest, DescribeIamInstanceProfileAssociationsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeIamInstanceProfileAssociationsCommand, serializeAws_ec2DescribeIamInstanceProfileAssociationsCommand, } from "../protocols/Aws_ec2";
var DescribeIamInstanceProfileAssociationsCommand = (function (_super) {
    __extends(DescribeIamInstanceProfileAssociationsCommand, _super);
    function DescribeIamInstanceProfileAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIamInstanceProfileAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIamInstanceProfileAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIamInstanceProfileAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIamInstanceProfileAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIamInstanceProfileAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIamInstanceProfileAssociationsCommand(input, context);
    };
    DescribeIamInstanceProfileAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIamInstanceProfileAssociationsCommand(output, context);
    };
    return DescribeIamInstanceProfileAssociationsCommand;
}($Command));
export { DescribeIamInstanceProfileAssociationsCommand };
