import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeHostsRequest, DescribeHostsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeHostsCommand, serializeAws_ec2DescribeHostsCommand } from "../protocols/Aws_ec2";
var DescribeHostsCommand = (function (_super) {
    __extends(DescribeHostsCommand, _super);
    function DescribeHostsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeHostsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeHostsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeHostsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeHostsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeHostsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeHostsCommand(input, context);
    };
    DescribeHostsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeHostsCommand(output, context);
    };
    return DescribeHostsCommand;
}($Command));
export { DescribeHostsCommand };
