import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeHostReservationOfferingsRequest, DescribeHostReservationOfferingsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeHostReservationOfferingsCommand, serializeAws_ec2DescribeHostReservationOfferingsCommand, } from "../protocols/Aws_ec2";
var DescribeHostReservationOfferingsCommand = (function (_super) {
    __extends(DescribeHostReservationOfferingsCommand, _super);
    function DescribeHostReservationOfferingsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeHostReservationOfferingsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeHostReservationOfferingsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeHostReservationOfferingsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeHostReservationOfferingsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeHostReservationOfferingsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeHostReservationOfferingsCommand(input, context);
    };
    DescribeHostReservationOfferingsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeHostReservationOfferingsCommand(output, context);
    };
    return DescribeHostReservationOfferingsCommand;
}($Command));
export { DescribeHostReservationOfferingsCommand };
