import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFleetsRequest, DescribeFleetsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFleetsCommand, serializeAws_ec2DescribeFleetsCommand } from "../protocols/Aws_ec2";
var DescribeFleetsCommand = (function (_super) {
    __extends(DescribeFleetsCommand, _super);
    function DescribeFleetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFleetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFleetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFleetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFleetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFleetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFleetsCommand(input, context);
    };
    DescribeFleetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFleetsCommand(output, context);
    };
    return DescribeFleetsCommand;
}($Command));
export { DescribeFleetsCommand };
