import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeExportTasksRequest, DescribeExportTasksResult } from "../models/models_3";
import { deserializeAws_ec2DescribeExportTasksCommand, serializeAws_ec2DescribeExportTasksCommand, } from "../protocols/Aws_ec2";
var DescribeExportTasksCommand = (function (_super) {
    __extends(DescribeExportTasksCommand, _super);
    function DescribeExportTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeExportTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeExportTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeExportTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeExportTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeExportTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeExportTasksCommand(input, context);
    };
    DescribeExportTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeExportTasksCommand(output, context);
    };
    return DescribeExportTasksCommand;
}($Command));
export { DescribeExportTasksCommand };
