import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeExportImageTasksRequest, DescribeExportImageTasksResult } from "../models/models_3";
import { deserializeAws_ec2DescribeExportImageTasksCommand, serializeAws_ec2DescribeExportImageTasksCommand, } from "../protocols/Aws_ec2";
var DescribeExportImageTasksCommand = (function (_super) {
    __extends(DescribeExportImageTasksCommand, _super);
    function DescribeExportImageTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeExportImageTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeExportImageTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeExportImageTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeExportImageTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeExportImageTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeExportImageTasksCommand(input, context);
    };
    DescribeExportImageTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeExportImageTasksCommand(output, context);
    };
    return DescribeExportImageTasksCommand;
}($Command));
export { DescribeExportImageTasksCommand };
