import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeElasticGpusRequest, DescribeElasticGpusResult } from "../models/models_3";
import { deserializeAws_ec2DescribeElasticGpusCommand, serializeAws_ec2DescribeElasticGpusCommand, } from "../protocols/Aws_ec2";
var DescribeElasticGpusCommand = (function (_super) {
    __extends(DescribeElasticGpusCommand, _super);
    function DescribeElasticGpusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeElasticGpusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeElasticGpusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeElasticGpusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeElasticGpusResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeElasticGpusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeElasticGpusCommand(input, context);
    };
    DescribeElasticGpusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeElasticGpusCommand(output, context);
    };
    return DescribeElasticGpusCommand;
}($Command));
export { DescribeElasticGpusCommand };
