import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeEgressOnlyInternetGatewaysRequest, DescribeEgressOnlyInternetGatewaysResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand, serializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeEgressOnlyInternetGatewaysCommand = (function (_super) {
    __extends(DescribeEgressOnlyInternetGatewaysCommand, _super);
    function DescribeEgressOnlyInternetGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeEgressOnlyInternetGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeEgressOnlyInternetGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeEgressOnlyInternetGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeEgressOnlyInternetGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeEgressOnlyInternetGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand(input, context);
    };
    DescribeEgressOnlyInternetGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand(output, context);
    };
    return DescribeEgressOnlyInternetGatewaysCommand;
}($Command));
export { DescribeEgressOnlyInternetGatewaysCommand };
