import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResult } from "../models/models_2";
import { deserializeAws_ec2DescribeAvailabilityZonesCommand, serializeAws_ec2DescribeAvailabilityZonesCommand, } from "../protocols/Aws_ec2";
var DescribeAvailabilityZonesCommand = (function (_super) {
    __extends(DescribeAvailabilityZonesCommand, _super);
    function DescribeAvailabilityZonesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeAvailabilityZonesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeAvailabilityZonesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeAvailabilityZonesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeAvailabilityZonesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeAvailabilityZonesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeAvailabilityZonesCommand(input, context);
    };
    DescribeAvailabilityZonesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeAvailabilityZonesCommand(output, context);
    };
    return DescribeAvailabilityZonesCommand;
}($Command));
export { DescribeAvailabilityZonesCommand };
