import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAddressesRequest, DescribeAddressesResult } from "../models/models_2";
import { deserializeAws_ec2DescribeAddressesCommand, serializeAws_ec2DescribeAddressesCommand, } from "../protocols/Aws_ec2";
var DescribeAddressesCommand = (function (_super) {
    __extends(DescribeAddressesCommand, _super);
    function DescribeAddressesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeAddressesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeAddressesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeAddressesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeAddressesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeAddressesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeAddressesCommand(input, context);
    };
    DescribeAddressesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeAddressesCommand(output, context);
    };
    return DescribeAddressesCommand;
}($Command));
export { DescribeAddressesCommand };
